/* These flags control compilation. Define either PC, OPENVIEW or UNIX.
 * For PCs define either CURSES or PCSPECIFIC.
 * For the PC, the best combination is PC and PCSPECIFIC although PC
 * and CURSES allows the curses version to be tested.
 *
 * For non-OPENVIEW UNIX, you must have CURSES set.
 * 
 * 1999.2.3 - the PC version needs 'Turbo C Tools version 5.00' by Blaise
 * Computing, which is unlikely to still be available. IT also needs the
 * PC-dependent source 'ibm.c'. This was last compiled by me in 1994 (???)
 * with Borland's Turbo-C 1.5. As this is just too hard and unlikely to
 * be of further interest, I will no longer support the DOS version.
 * If this is a problem, please contact me bhepple@bit.net.au

    Contact info:
    bhepple@bit.net.au
    http://www.bit.net.au/~bhepple/dcalc

    Copyright (C) 1999 Bob Hepple

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

 */

#undef	PC
#define	UNIX 1
#undef OPENVIEW

#ifdef PC
#undef   CURSES
#define  PCSPECIFIC      1
/* Set this if you want a TSR function with mouse capture */
#undef	 TSR
#endif

/* If you set PCSPECIFIC then you need to compile and link dcalc.c with
 * ibm.c as well as the special version of ivctrl.obj
 * (munged to support the 101-key keyboard) as well as Blaise's tct_t1s.lib.
 * Compile everything with TurboC 1.5 in the small model.
 *
 * For CURSES, you need to compile and link curse.c and dcalc.c with the curses
 * library.
 *
 * For OPENVIEW, you need to compile and link openview.c, ov_ui.c, ov_stubs.c
 * and dcalc.c with the appropriate libraries.
 */

/* End of flags. The previous flags are all you should have to touch. */
/**********************************************************************/

#ifdef UNIX
#define CURSES		1
#undef  PCSPECIFIC
#undef  OPENVIEW
#endif

#ifdef __TURBOC__
#define REVERSE_BYTES	1
#else
#define REVERSE_BYTES	0
#endif

#define ASCIIZ '\0'
#define SPECIAL ASCIIZ

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif

/* Keys we are interested in ... */
#define BELL	7
#define SPACE	' '
#define COMMA   ','
#define BACKSPACE 8
#define ESCAPE	27

#if PCSPECIFIC
#define F1KEY	073
#define F2KEY	074
#define F3KEY	075
#define F4KEY	076
#define F5KEY	077
#define F6KEY	010
#define F7KEY	0101
#define F8KEY	0102
#define F9KEY	0103
#define F10KEY	0104
#define HOMEKEY	0107
#define ENDKEY  0117
#define UPKEY	0110
#define LEFTKEY	0113
#define RIGHTKEY 0115
#define DOWNKEY	0120
#define ROLLKEY	0121
#define DELKEY	0123
#define NEXTKEY	0121
#define PREVKEY	0111
#endif /* PCSPECIFIC */

/* screen addresses ... */
#define LEFTSIDE	0
#define START_X		1
#define STARTL_Y	10
#define STARTT_Y	11
#define STARTZ_Y	12
#define STARTY_Y	13
#define STARTX_Y	1
#define BASE_X		0
#define BASE_Y		0
#define FK_X		0
#define FK_Y		0
#define INV_X		9
#define INV_Y		0
#define TMODE_X		19
#define TMODE_Y		0
#define INTLINEX	2
#define INTLINEY	11
#define ERRORX		0
#define ERRORY		0
#define WIDTH		36

#define COMMAND int

struct funckey {
	char label[8];
	COMMAND function;
};

/* COMMANDS (in addition to 'normal' keys ... */
#define MIN_COMMAND 0x200
#define ASCIIM	0x200
#define FLOAT	0x201
#define BIN  	0x202
#define OCT  	0x203
#define DEC  	0x204
#define HEX  	0x205

#define INV  	0x206
#define SIN  	0x207
#define COS  	0x210
#define TAN  	0x211
#define SINH 	0x212
#define COSH 	0x213
#define TANH 	0x214
#define LOGE 	0x215
#define LOG10	0x216

#define SQR  	0x217
#define ROOT 	0x220
#define CUBE 	0x221
#define CROOT	0x222
#define FRC  	0x223
#define INT  	0x224

#define SUM  	0x225
#define SUM0 	0x226
#define SUMR 	0x227
#define MEAN 	0x230
#define S_DEV	0x231
#define NSTAT	0x232

#define NFIN 	0x233
#define INTST	0x234
#define PMT  	0x235
#define PVAL 	0x236
#define FVAL 	0x237
#define ENG  	0x240
#define ETOX	0x241
#define RECI	0x242

#define ROLLDOWN	0x300
#define CLX     	0x301
#define QUIT		0x303
#define NEXTKEYS	0x305
#define PREVKEYS	0x307
#define ENTER		0x311

#define F1	0x340
#define F2	0x341
#define F3	0x342
#define F4	0x343
#define F5	0x344
#define F6	0x345
#define F7	0x346
#define F8	0x347
#define F9	0x350
#define F10	0x351

#define BOX_CALC	0x360
#define RETURN_X	0x361
#define HELP		0x363
#define NOP		0x365

/* ... END OF COMMANDS */

#define BOOLEAN int

#define NUMREGS 10
#define NUMFK 5
#define MSG_SIZE 42

#define DEF_SIG "DCALC Version 2.4 - by Bob Hepple"
