/* Simple program to add (or - * /) a file of numbers read from stdin

    Contact info:
    bhepple@bit.net.au
    http://www.bit.net.au/~bhepple/dcalc

    Copyright (C) 1999 Bob Hepple

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

*/

#include <stdio.h>
#include <ctype.h>

#define FALSE 0
#define TRUE 1

int get_value(value)
     double	*value;
{
	int	s = ' ',
		dot_legal =	TRUE, 
	        exp_legal =	TRUE, 
		sign_legal =	TRUE, 
		number_found =	FALSE;
	char	buf[80], *p = buf;
	extern	double	atof();

	/* skip until we hit a number */
	while ((s != EOF) &&
	       (!isdigit(s)) &&
	       (s != '+') &&
	       (s != '-') &&
               (s != '.'))
                s = getchar();

	while ((s != EOF) &&
	       (
		(isdigit(s))				||
		((s == '.') && dot_legal)		||
		((toupper(s) == 'E') && exp_legal)	||
		((s == '-') && sign_legal)
	       )
	      ) {
		*p++ = s;
		*p = 0;

		if (s == '.') {
			dot_legal = FALSE;
			sign_legal = FALSE;
		}
		if (isdigit(s))
			sign_legal = FALSE;
		if (s == '-')
			sign_legal = FALSE;
		if (toupper(s) == 'E') {
			exp_legal = FALSE;
			sign_legal = TRUE;
			dot_legal = FALSE;
		}

		number_found = TRUE;

		s = getchar();
	}

	if (number_found)
		*value = atof(buf);
	else
		*value = 0.0;
	return(number_found);
}

int main(argc, argv)
        int	argc;
        char	**argv;
{
	int		i, op;
	double		tempf, xf;
	
	if (argc > 1)
		op = *argv[1];
	else
		op = '+';

	if (get_value(&tempf))
		while (get_value(&xf))
			switch (op) {
			      case '+':
				tempf += xf;
				break;
			      case '-':
				tempf -= xf;
				break;
			      case '*':
				tempf *= xf;
				break;
			      case '/':
				if (xf != 0.0)
					tempf /= xf;
				break;
			      default:
				puts("Bad operator\n");
				exit(1);
			}
	printf("%lf\n", tempf);
	exit(0);
}
