/********** Exemple d'utilisation de l'API C/MySQL ************/

/*
Pour fonctionner, ce programme necessite un serveur MySQL,
sur ce serveur une base, dans cette base une table, et eventuellement
dans cette table des enregistrements. Il faut aussi bien sur disposer
d'un compte sur le serveur.
Je vous conseillerai enfin de proceder comme suit :
Repetez
	modifier le fichier source,
	compiler le programme (gcc -W -Wall -lmysqlclient -o mysql_test mysql_test.c),
	lancer l'executable
tant que ca marche pas.
*/


#include <mysql/mysql.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/* Les parametres ci-dessous sont a adapter a votre situation */
#define MY_SERVER_HOST "localhost"
#define MY_SERVER_PORT 0
#define MY_ACCOUNT "login"
#define MY_PASS "password"
#define MY_DB_NAME "test"
#define MY_TABLE_NAME "test_tbl"
#define MY_UX_SOCK NULL
#define MY_CLIENT_FLAG 0

int main(){
   MYSQL *mysql;
   MYSQL_RES *res;
   MYSQL_ROW row;
   char *query;
   unsigned int t, f;

   mysql=mysql_init(NULL);
   if (!mysql_real_connect(mysql,MY_SERVER_HOST,MY_ACCOUNT,MY_PASS,
        MY_DB_NAME,MY_SERVER_PORT,MY_UX_SOCK,MY_CLIENT_FLAG)) {
       printf( "Erreur de connexion : %s\n",mysql_error(mysql));
   } else {
      printf("Connexion etablie...\n");
      
      sprintf(query,"select * from %s\n", MY_TABLE_NAME);
      printf("Requete : %s", query);
      
      t=mysql_real_query(mysql, query, (unsigned int) strlen(query));
      if (t) {
         printf("Erreur dans la requete : %s\n", mysql_error(mysql));
      } else {
         if((res=mysql_use_result(mysql))) {
            printf("Resultat de la requete :\n");
            f=mysql_num_fields(res);
            while((row=mysql_fetch_row(res))) {
              for(t=0;t<f;t++) {
                printf("\t%s",row[t]);
              }
              printf("\n");
            }
	           mysql_free_result(res);
         }
         else {
           printf("Erreur de recuperation du resultat : %s\n", mysql_error(mysql));
         }
      }
   }
   mysql_close(mysql);
   exit(EXIT_SUCCESS);
}
