/* -------------------------------------------------------------------- *
 * master_pvm.c															*
 * 																		*
 * This is the master program for the simple PVM demonstration.			*
 * -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <pvm3.h>			/* declares PVM constants and functions	*/
#include <string.h>

int main()
{
	int mytid;				/* our task ID			*/
	int slave_tid;			/* task ID of the slave	*/
	int result;
	char message[] = "hello pvm";
	
	/* enroll ourselves into the PVM system and get our ID */
	mytid = pvm_mytid();

	/* spawn the slave */
	result = pvm_spawn("slave_pvm", (char**)0, PvmTaskDefault, 
			            "", 1, &slave_tid);

	/* check if the slave was spawned successfully			*/
	if(result != 1)
	{
		fprintf(stderr, "Error: Cannot spawn slave.\n");

		/* clean up and exit from the PVM system			*/
		pvm_exit();
		exit(EXIT_FAILURE);
	}

	/* initialize the data buffer to send data to slave		*/
	pvm_initsend(PvmDataDefault);

	/* ``pack'' the string into the data buffer				*/
	pvm_pkstr(message);

	/* send the string to the slave with a message tag of 0	*/
	pvm_send(slave_tid, 0);

	/* wait and receive the result string from the slave	*/
	pvm_recv(slave_tid, 0);

	
	/* ``unpack'' the result from the slave					*/
	pvm_upkstr(message);

	/* show the result from the slave						*/
	printf("Data from the slave : %s\n", message);

	/* clean up and exit from the PVM system				*/
	pvm_exit();
	
	exit(EXIT_SUCCESS);
} /* end main() */

/* end master_pvm.c */
	
